unit formMain;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Borland.Eco.WinForm, Borland.Eco.Handles, MeetingManagerEcoSpace, CoreClassesUnit;

type
  TWinFormMain = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    EcoActionExtender: Borland.Eco.WinForm.EcoActionExtender;
    EcoAutoFormExtender: Borland.Eco.WinForm.EcoAutoFormExtender;
    EcoListActionExtender: Borland.Eco.WinForm.EcoListActionExtender;
    dgridMeetings: System.Windows.Forms.DataGrid;
    dgridParticipants: System.Windows.Forms.DataGrid;
    btnNewMeeting: System.Windows.Forms.Button;
    btnDeleteMeeting: System.Windows.Forms.Button;
    btnNewPerson: System.Windows.Forms.Button;
    btnDeleteParticipant: System.Windows.Forms.Button;
    btnSave: System.Windows.Forms.Button;
    btnUndo: System.Windows.Forms.Button;
    btnRedo: System.Windows.Forms.Button;
    EcoDragDropExtender: Borland.Eco.WinForm.EcoDragDropExtender;
    ehParticipants: Borland.Eco.Handles.ExpressionHandle;
    ehMeetings: Borland.Eco.Handles.ExpressionHandle;
    cmhCurrentParticipant: Borland.Eco.Handles.CurrencyManagerHandle;
    ehMeetingParticipants: Borland.Eco.Handles.ExpressionHandle;
    cmhCurrentMeeting: Borland.Eco.Handles.CurrencyManagerHandle;

    dgridMeetingParticipants: System.Windows.Forms.DataGrid;
    tabControlMain: System.Windows.Forms.TabControl;
    tabMeetings: System.Windows.Forms.TabPage;
    Panel1: System.Windows.Forms.Panel;
    tabParticipants: System.Windows.Forms.TabPage;
    ehParticipantGroups: Borland.Eco.Handles.ExpressionHandle;
    tboxMeetingFrom: System.Windows.Forms.TextBox;
    lblMeetingEndTime: System.Windows.Forms.Label;
    grboxCurrentMeeting: System.Windows.Forms.GroupBox;
    tboxMeetingDuration: System.Windows.Forms.TextBox;
    lblStartTime: System.Windows.Forms.Label;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    gboxParticpants: System.Windows.Forms.GroupBox;
    Panel2: System.Windows.Forms.Panel;
    Panel3: System.Windows.Forms.Panel;
    rbtnAllParticipants: System.Windows.Forms.RadioButton;
    rbtnConfirmedParticipants: System.Windows.Forms.RadioButton;
    ehMeetingParticipantsConfirmed: Borland.Eco.Handles.ExpressionHandle;
    Confirmed: System.Windows.Forms.DataGridTextBoxColumn;
    Panel4: System.Windows.Forms.Panel;
    dgridMeetingParticipantsConfirmed: System.Windows.Forms.DataGrid;
    btnNewResource: System.Windows.Forms.Button;
    btnNewGroup: System.Windows.Forms.Button;
    dgridParticipantGroups: System.Windows.Forms.DataGrid;
    Panel6: System.Windows.Forms.Panel;
    Panel5: System.Windows.Forms.Panel;
    Panel7: System.Windows.Forms.Panel;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents ofecospace this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnNewPerson_Click(sender: System.Object; e: System.EventArgs);
    procedure btnNewMeeting_Click(sender: System.Object; e: System.EventArgs);
    procedure rbtnConfirmedParticipants_Click(sender: System.Object; e: System.EventArgs);
    procedure btnNewGroup_Click(sender: System.Object; e: System.EventArgs);
    procedure btnNewResource_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    FEcoSpace: TMeetingManagerEcoSpace;
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
    property EcoSpace: TMeetingManagerEcoSpace read FEcoSpace;
  end;

implementation

uses
  System.Globalization;

procedure TWinFormMain.rbtnConfirmedParticipants_Click(sender: System.Object;
  e: System.EventArgs);
begin
  // Done: switching between filtered (derived association) view and all view
  dgridMeetingParticipants.Visible := rbtnAllParticipants.Checked;
end;

procedure TWinFormMain.btnNewMeeting_Click(sender: System.Object; e: System.EventArgs);
begin
  // Done: creating a meeting with default values
  with Meeting.Create(EcoSpace) do
  begin
    Subject := 'default';
    Time    := System.DateTime.Now;
    Duration := 30;
  end;
end;

procedure TWinFormMain.btnNewGroup_Click(sender: System.Object; e: System.EventArgs);
begin
  // Done : create a group default values
  Group.Create(EcoSpace).Name := 'default group name';
end;

procedure TWinFormMain.btnNewPerson_Click(sender: System.Object; e: System.EventArgs);
begin
  // Done : create a person with default values
  Person.Create(EcoSpace).Name := 'default name';
end;

procedure TWinFormMain.btnNewResource_Click(sender: System.Object; e: System.EventArgs);
begin
  // Done : create a group default values
  with Resource.Create(EcoSpace) do
  begin
    Name := 'default resource name';
    Kind := 'MeetingRoom';
  end;
end;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinFormMain.InitializeComponent;
type
  TArrayOfBorland_Eco_Handles_AbstractColumn = array of Borland.Eco.Handles.AbstractColumn;
var
  Column18: Borland.Eco.Handles.Column;
  Column17: Borland.Eco.Handles.Column;
  Column16: Borland.Eco.Handles.Column;
  Column15: Borland.Eco.Handles.Column;
  Column14: Borland.Eco.Handles.Column;
  Column13: Borland.Eco.Handles.Column;
  Column12: Borland.Eco.Handles.Column;
  Column11: Borland.Eco.Handles.Column;
begin
  Column11 := Borland.Eco.Handles.Column.Create;
  Column12 := Borland.Eco.Handles.Column.Create;
  Column13 := Borland.Eco.Handles.Column.Create;
  Column14 := Borland.Eco.Handles.Column.Create;
  Column15 := Borland.Eco.Handles.Column.Create;
  Column16 := Borland.Eco.Handles.Column.Create;
  Column17 := Borland.Eco.Handles.Column.Create;
  Column18 := Borland.Eco.Handles.Column.Create;
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.EcoActionExtender := Borland.Eco.WinForm.EcoActionExtender.Create;
  Self.btnSave := System.Windows.Forms.Button.Create;
  Self.btnUndo := System.Windows.Forms.Button.Create;
  Self.btnRedo := System.Windows.Forms.Button.Create;
  Self.EcoAutoFormExtender := Borland.Eco.WinForm.EcoAutoFormExtender.Create;
  Self.dgridMeetings := System.Windows.Forms.DataGrid.Create;
  Self.ehMeetings := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.dgridParticipants := System.Windows.Forms.DataGrid.Create;
  Self.ehParticipants := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.dgridParticipantGroups := System.Windows.Forms.DataGrid.Create;
  Self.ehParticipantGroups := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.cmhCurrentParticipant := Borland.Eco.Handles.CurrencyManagerHandle.Create;
  Self.EcoListActionExtender := Borland.Eco.WinForm.EcoListActionExtender.Create;
  Self.btnDeleteParticipant := System.Windows.Forms.Button.Create;
  Self.btnDeleteMeeting := System.Windows.Forms.Button.Create;
  Self.btnNewMeeting := System.Windows.Forms.Button.Create;
  Self.cmhCurrentMeeting := Borland.Eco.Handles.CurrencyManagerHandle.Create;
  Self.btnNewPerson := System.Windows.Forms.Button.Create;
  Self.EcoDragDropExtender := Borland.Eco.WinForm.EcoDragDropExtender.Create;
  Self.dgridMeetingParticipants := System.Windows.Forms.DataGrid.Create;
  Self.ehMeetingParticipants := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.dgridMeetingParticipantsConfirmed := System.Windows.Forms.DataGrid.Create;
  Self.ehMeetingParticipantsConfirmed := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.Confirmed := System.Windows.Forms.DataGridTextBoxColumn.Create;
  Self.tabControlMain := System.Windows.Forms.TabControl.Create;
  Self.tabMeetings := System.Windows.Forms.TabPage.Create;
  Self.Panel1 := System.Windows.Forms.Panel.Create;
  Self.grboxCurrentMeeting := System.Windows.Forms.GroupBox.Create;
  Self.Panel2 := System.Windows.Forms.Panel.Create;
  Self.rbtnConfirmedParticipants := System.Windows.Forms.RadioButton.Create;
  Self.rbtnAllParticipants := System.Windows.Forms.RadioButton.Create;
  Self.lblMeetingEndTime := System.Windows.Forms.Label.Create;
  Self.tboxMeetingFrom := System.Windows.Forms.TextBox.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.lblStartTime := System.Windows.Forms.Label.Create;
  Self.tboxMeetingDuration := System.Windows.Forms.TextBox.Create;
  Self.Panel4 := System.Windows.Forms.Panel.Create;
  Self.tabParticipants := System.Windows.Forms.TabPage.Create;
  Self.Panel6 := System.Windows.Forms.Panel.Create;
  Self.gboxParticpants := System.Windows.Forms.GroupBox.Create;
  Self.Panel7 := System.Windows.Forms.Panel.Create;
  Self.Panel5 := System.Windows.Forms.Panel.Create;
  Self.btnNewGroup := System.Windows.Forms.Button.Create;
  Self.btnNewResource := System.Windows.Forms.Button.Create;
  Self.Panel3 := System.Windows.Forms.Panel.Create;
  (System.ComponentModel.ISupportInitialize(Self.dgridMeetings)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dgridParticipants)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dgridParticipantGroups)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dgridMeetingParticipants)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dgridMeetingParticipantsConfirmed)).BeginInit;
  Self.tabControlMain.SuspendLayout;
  Self.tabMeetings.SuspendLayout;
  Self.Panel1.SuspendLayout;
  Self.grboxCurrentMeeting.SuspendLayout;
  Self.Panel2.SuspendLayout;
  Self.Panel4.SuspendLayout;
  Self.tabParticipants.SuspendLayout;
  Self.Panel6.SuspendLayout;
  Self.gboxParticpants.SuspendLayout;
  Self.Panel7.SuspendLayout;
  Self.Panel5.SuspendLayout;
  Self.Panel3.SuspendLayout;
  Self.SuspendLayout;
  // 
  // EcoActionExtender
  // 
  Self.EcoActionExtender.RootHandle := Self.rhRoot;
  // 
  // btnSave
  // 
  Self.btnSave.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoActionExtender.SetEcoAction(Self.btnSave, Borland.Eco.WinForm.EcoAction.UpdateDatabase);
  Self.btnSave.Location := System.Drawing.Point.Create(579, 8);
  Self.btnSave.Name := 'btnSave';
  Self.btnSave.TabIndex := 6;
  Self.btnSave.Text := 'Save';
  // 
  // btnUndo
  // 
  Self.btnUndo.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoActionExtender.SetEcoAction(Self.btnUndo, Borland.Eco.WinForm.EcoAction.Undo);
  Self.btnUndo.Location := System.Drawing.Point.Create(400, 8);
  Self.btnUndo.Name := 'btnUndo';
  Self.btnUndo.TabIndex := 7;
  Self.btnUndo.Text := 'Undo';
  // 
  // btnRedo
  // 
  Self.btnRedo.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.EcoActionExtender.SetEcoAction(Self.btnRedo, Borland.Eco.WinForm.EcoAction.Redo);
  Self.btnRedo.Location := System.Drawing.Point.Create(480, 8);
  Self.btnRedo.Name := 'btnRedo';
  Self.btnRedo.TabIndex := 8;
  Self.btnRedo.Text := 'Redo';
  // 
  // dgridMeetings
  // 
  Self.dgridMeetings.AlternatingBackColor := System.Drawing.Color.WhiteSmoke;
  Self.dgridMeetings.BackColor := System.Drawing.Color.Gainsboro;
  Self.dgridMeetings.BackgroundColor := System.Drawing.Color.DarkGray;
  Self.dgridMeetings.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.dgridMeetings.CaptionBackColor := System.Drawing.Color.DarkKhaki;
  Self.dgridMeetings.CaptionFont := System.Drawing.Font.Create('Microsoft Sa' +
    'ns Serif', 8);
  Self.dgridMeetings.CaptionForeColor := System.Drawing.Color.Black;
  Self.dgridMeetings.CaptionText := 'Meetings';
  Self.dgridMeetings.DataMember := '';
  Self.dgridMeetings.DataSource := Self.ehMeetings;
  Self.dgridMeetings.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.EcoAutoFormExtender.SetEcoAutoForm(Self.dgridMeetings, True);
  Self.dgridMeetings.FlatMode := True;
  Self.dgridMeetings.Font := System.Drawing.Font.Create('Microsoft Sans Seri' +
    'f', 8);
  Self.dgridMeetings.ForeColor := System.Drawing.Color.Black;
  Self.dgridMeetings.GridLineColor := System.Drawing.Color.Silver;
  Self.dgridMeetings.HeaderBackColor := System.Drawing.Color.Black;
  Self.dgridMeetings.HeaderFont := System.Drawing.Font.Create('Microsoft San' +
    's Serif', 8);
  Self.dgridMeetings.HeaderForeColor := System.Drawing.Color.White;
  Self.dgridMeetings.LinkColor := System.Drawing.Color.DarkSlateBlue;
  Self.dgridMeetings.Location := System.Drawing.Point.Create(3, 3);
  Self.dgridMeetings.Name := 'dgridMeetings';
  Self.dgridMeetings.ParentRowsBackColor := System.Drawing.Color.LightGray;
  Self.dgridMeetings.ParentRowsForeColor := System.Drawing.Color.Black;
  Self.dgridMeetings.RowHeaderWidth := 25;
  Self.dgridMeetings.SelectionBackColor := System.Drawing.Color.Firebrick;
  Self.dgridMeetings.SelectionForeColor := System.Drawing.Color.White;
  Self.dgridMeetings.Size := System.Drawing.Size.Create(388, 434);
  Self.dgridMeetings.TabIndex := 1;
  // 
  // ehMeetings
  // 
  Column11.Expression := 'self.Participancy->select(confirmed).participants-' +
  '>size';
  Column11.Name := 'Confirmed';
  Self.ehMeetings.Columns.AddRange(TArrayOfBorland_Eco_Handles_AbstractColumn.Create(Column11));
  Self.ehMeetings.Expression := 'Meeting.allInstances->orderby(time)';
  Self.ehMeetings.RootHandle := Self.rhRoot;
  // 
  // dgridParticipants
  // 
  Self.dgridParticipants.AlternatingBackColor := System.Drawing.Color.WhiteSmoke;
  Self.dgridParticipants.BackColor := System.Drawing.Color.Gainsboro;
  Self.dgridParticipants.BackgroundColor := System.Drawing.Color.DarkGray;
  Self.dgridParticipants.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.dgridParticipants.CaptionBackColor := System.Drawing.Color.DarkKhaki;
  Self.dgridParticipants.CaptionFont := System.Drawing.Font.Create('Microsof' +
    't Sans Serif', 8);
  Self.dgridParticipants.CaptionForeColor := System.Drawing.Color.Black;
  Self.dgridParticipants.CaptionText := 'Persons, Resources & Groups';
  Self.dgridParticipants.DataMember := '';
  Self.dgridParticipants.DataSource := Self.ehParticipants;
  Self.dgridParticipants.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.EcoAutoFormExtender.SetEcoAutoForm(Self.dgridParticipants, True);
  Self.EcoDragDropExtender.SetEcoDragSource(Self.dgridParticipants, True);
  Self.dgridParticipants.FlatMode := True;
  Self.dgridParticipants.Font := System.Drawing.Font.Create('Microsoft Sans ' +
    'Serif', 8);
  Self.dgridParticipants.ForeColor := System.Drawing.Color.Black;
  Self.dgridParticipants.GridLineColor := System.Drawing.Color.Silver;
  Self.dgridParticipants.HeaderBackColor := System.Drawing.Color.Black;
  Self.dgridParticipants.HeaderFont := System.Drawing.Font.Create('Microsoft' +
    ' Sans Serif', 8);
  Self.dgridParticipants.HeaderForeColor := System.Drawing.Color.White;
  Self.dgridParticipants.LinkColor := System.Drawing.Color.DarkSlateBlue;
  Self.dgridParticipants.Location := System.Drawing.Point.Create(3, 3);
  Self.dgridParticipants.Name := 'dgridParticipants';
  Self.dgridParticipants.ParentRowsBackColor := System.Drawing.Color.LightGray;
  Self.dgridParticipants.ParentRowsForeColor := System.Drawing.Color.Black;
  Self.dgridParticipants.SelectionBackColor := System.Drawing.Color.Firebrick;
  Self.dgridParticipants.SelectionForeColor := System.Drawing.Color.White;
  Self.dgridParticipants.Size := System.Drawing.Size.Create(388, 434);
  Self.dgridParticipants.TabIndex := 1;
  // 
  // ehParticipants
  // 
  Column12.Expression := '''(''+self.asstring+'')''';
  Column12.Name := 'Type';
  Self.ehParticipants.Columns.AddRange(TArrayOfBorland_Eco_Handles_AbstractColumn.Create(Column12));
  Self.ehParticipants.Expression := 'Participant.allInstances';
  Self.ehParticipants.RootHandle := Self.rhRoot;
  // 
  // dgridParticipantGroups
  // 
  Self.dgridParticipantGroups.AllowDrop := True;
  Self.dgridParticipantGroups.AlternatingBackColor := System.Drawing.Color.WhiteSmoke;
  Self.dgridParticipantGroups.BackColor := System.Drawing.Color.Gainsboro;
  Self.dgridParticipantGroups.BackgroundColor := System.Drawing.Color.DarkGray;
  Self.dgridParticipantGroups.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.dgridParticipantGroups.CaptionBackColor := System.Drawing.Color.DarkKhaki;
  Self.dgridParticipantGroups.CaptionFont := System.Drawing.Font.Create('Mic' +
    'rosoft Sans Serif', 8);
  Self.dgridParticipantGroups.CaptionForeColor := System.Drawing.Color.Black;
  Self.dgridParticipantGroups.CaptionText := 'Selected participant member in' +
  ' groups';
  Self.dgridParticipantGroups.DataMember := '';
  Self.dgridParticipantGroups.DataSource := Self.ehParticipantGroups;
  Self.dgridParticipantGroups.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.EcoAutoFormExtender.SetEcoAutoForm(Self.dgridParticipantGroups, True);
  Self.dgridParticipantGroups.FlatMode := True;
  Self.dgridParticipantGroups.Font := System.Drawing.Font.Create('Microsoft ' +
    'Sans Serif', 8);
  Self.dgridParticipantGroups.ForeColor := System.Drawing.Color.Black;
  Self.dgridParticipantGroups.GridLineColor := System.Drawing.Color.Silver;
  Self.dgridParticipantGroups.HeaderBackColor := System.Drawing.Color.Black;
  Self.dgridParticipantGroups.HeaderFont := System.Drawing.Font.Create('Micr' +
    'osoft Sans Serif', 8);
  Self.dgridParticipantGroups.HeaderForeColor := System.Drawing.Color.White;
  Self.dgridParticipantGroups.LinkColor := System.Drawing.Color.DarkSlateBlue;
  Self.dgridParticipantGroups.Location := System.Drawing.Point.Create(3, 80);
  Self.dgridParticipantGroups.Name := 'dgridParticipantGroups';
  Self.dgridParticipantGroups.ParentRowsBackColor := System.Drawing.Color.LightGray;
  Self.dgridParticipantGroups.ParentRowsForeColor := System.Drawing.Color.Black;
  Self.dgridParticipantGroups.SelectionBackColor := System.Drawing.Color.Firebrick;
  Self.dgridParticipantGroups.SelectionForeColor := System.Drawing.Color.White;
  Self.dgridParticipantGroups.Size := System.Drawing.Size.Create(244, 247);
  Self.dgridParticipantGroups.TabIndex := 19;
  // 
  // ehParticipantGroups
  // 
  Self.ehParticipantGroups.Expression := 'self.groups';
  Self.ehParticipantGroups.RootHandle := Self.cmhCurrentParticipant;
  // 
  // cmhCurrentParticipant
  // 
  Self.cmhCurrentParticipant.BindingContext := Self.dgridParticipants;
  Self.cmhCurrentParticipant.RootHandle := Self.ehParticipants;
  // 
  // btnDeleteParticipant
  // 
  Self.EcoListActionExtender.SetBindingContext(Self.btnDeleteParticipant, Self.dgridParticipants);
  Self.EcoListActionExtender.SetEcoListAction(Self.btnDeleteParticipant, Borland.Eco.WinForm.ListAction.Delete);
  Self.btnDeleteParticipant.ImageIndex := 2;
  Self.btnDeleteParticipant.Location := System.Drawing.Point.Create(136, 8);
  Self.btnDeleteParticipant.Name := 'btnDeleteParticipant';
  Self.EcoListActionExtender.SetRootHandle(Self.btnDeleteParticipant, Self.ehParticipants);
  Self.btnDeleteParticipant.Size := System.Drawing.Size.Create(96, 23);
  Self.btnDeleteParticipant.TabIndex := 5;
  Self.btnDeleteParticipant.Text := 'Delete';
  // 
  // btnDeleteMeeting
  // 
  Self.EcoListActionExtender.SetBindingContext(Self.btnDeleteMeeting, Self.dgridMeetings);
  Self.EcoListActionExtender.SetEcoListAction(Self.btnDeleteMeeting, Borland.Eco.WinForm.ListAction.Delete);
  Self.btnDeleteMeeting.ImageIndex := 2;
  Self.btnDeleteMeeting.Location := System.Drawing.Point.Create(145, 0);
  Self.btnDeleteMeeting.Name := 'btnDeleteMeeting';
  Self.EcoListActionExtender.SetRootHandle(Self.btnDeleteMeeting, Self.ehMeetings);
  Self.btnDeleteMeeting.Size := System.Drawing.Size.Create(96, 23);
  Self.btnDeleteMeeting.TabIndex := 16;
  Self.btnDeleteMeeting.Text := 'Delete';
  // 
  // btnNewMeeting
  // 
  Self.EcoListActionExtender.SetEcoListAction(Self.btnNewMeeting, Borland.Eco.WinForm.ListAction.Add);
  Self.btnNewMeeting.ImageIndex := 1;
  Self.btnNewMeeting.Location := System.Drawing.Point.Create(148, 4);
  Self.btnNewMeeting.Name := 'btnNewMeeting';
  Self.EcoListActionExtender.SetRootHandle(Self.btnNewMeeting, Self.ehMeetings);
  Self.btnNewMeeting.Size := System.Drawing.Size.Create(96, 23);
  Self.btnNewMeeting.TabIndex := 16;
  Self.btnNewMeeting.Text := 'Add';
  Include(Self.btnNewMeeting.Click, Self.btnNewMeeting_Click);
  // 
  // cmhCurrentMeeting
  // 
  Self.cmhCurrentMeeting.BindingContext := Self.dgridMeetings;
  Column13.Expression := '''Meeting: ''+ self.Subject + if not self.Time.IsN' +
  'ull and not self.endtime.isNull then '' ( '' + self.Time.asstring + '' ..' +
  ' '' + self.endtime.asstring + '' )'' else '''' endif';
  Column13.Name := 'Caption';
  Self.cmhCurrentMeeting.Columns.AddRange(TArrayOfBorland_Eco_Handles_AbstractColumn.Create(Column13));
  Self.cmhCurrentMeeting.RootHandle := Self.ehMeetings;
  // 
  // btnNewPerson
  // 
  Self.btnNewPerson.Location := System.Drawing.Point.Create(137, 8);
  Self.btnNewPerson.Name := 'btnNewPerson';
  Self.btnNewPerson.Size := System.Drawing.Size.Create(96, 23);
  Self.btnNewPerson.TabIndex := 4;
  Self.btnNewPerson.Text := 'New Person';
  Include(Self.btnNewPerson.Click, Self.btnNewPerson_Click);
  // 
  // dgridMeetingParticipants
  // 
  Self.dgridMeetingParticipants.AlternatingBackColor := System.Drawing.Color.WhiteSmoke;
  Self.dgridMeetingParticipants.BackColor := System.Drawing.Color.Gainsboro;
  Self.dgridMeetingParticipants.BackgroundColor := System.Drawing.Color.DarkGray;
  Self.dgridMeetingParticipants.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.dgridMeetingParticipants.CaptionBackColor := System.Drawing.Color.DarkKhaki;
  Self.dgridMeetingParticipants.CaptionFont := System.Drawing.Font.Create('M' +
    'icrosoft Sans Serif', 8);
  Self.dgridMeetingParticipants.CaptionForeColor := System.Drawing.Color.Black;
  Self.dgridMeetingParticipants.CaptionText := 'Participants in selected mee' +
  'ting';
  Self.dgridMeetingParticipants.DataMember := '';
  Self.dgridMeetingParticipants.DataSource := Self.ehMeetingParticipants;
  Self.dgridMeetingParticipants.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.EcoDragDropExtender.SetEcoDropTarget(Self.dgridMeetingParticipants, True);
  Self.dgridMeetingParticipants.FlatMode := True;
  Self.dgridMeetingParticipants.Font := System.Drawing.Font.Create('Microsof' +
    't Sans Serif', 8);
  Self.dgridMeetingParticipants.ForeColor := System.Drawing.Color.Black;
  Self.dgridMeetingParticipants.GridLineColor := System.Drawing.Color.Silver;
  Self.dgridMeetingParticipants.HeaderBackColor := System.Drawing.Color.Black;
  Self.dgridMeetingParticipants.HeaderFont := System.Drawing.Font.Create('Mi' +
    'crosoft Sans Serif', 8);
  Self.dgridMeetingParticipants.HeaderForeColor := System.Drawing.Color.White;
  Self.dgridMeetingParticipants.LinkColor := System.Drawing.Color.DarkSlateBlue;
  Self.dgridMeetingParticipants.Location := System.Drawing.Point.Create(3, 152);
  Self.dgridMeetingParticipants.Name := 'dgridMeetingParticipants';
  Self.dgridMeetingParticipants.ParentRowsBackColor := System.Drawing.Color.LightGray;
  Self.dgridMeetingParticipants.ParentRowsForeColor := System.Drawing.Color.Black;
  Self.dgridMeetingParticipants.RowHeadersVisible := False;
  Self.dgridMeetingParticipants.SelectionBackColor := System.Drawing.Color.Firebrick;
  Self.dgridMeetingParticipants.SelectionForeColor := System.Drawing.Color.White;
  Self.dgridMeetingParticipants.Size := System.Drawing.Size.Create(247, 247);
  Self.dgridMeetingParticipants.TabIndex := 17;
  // 
  // ehMeetingParticipants
  // 
  Column14.Expression := 'self.Confirmed';
  Column14.Name := 'Confirmed';
  Column15.Expression := 'self.participants.Name';
  Column15.Name := 'Name';
  Column16.Expression := 'self.participants.asstring';
  Column16.Name := 'Type';
  Self.ehMeetingParticipants.Columns.AddRange(TArrayOfBorland_Eco_Handles_AbstractColumn.Create(Column14, 
          Column15, Column16));
  Self.ehMeetingParticipants.Expression := 'self.Participancy';
  Self.ehMeetingParticipants.RootHandle := Self.cmhCurrentMeeting;
  // 
  // dgridMeetingParticipantsConfirmed
  // 
  Self.dgridMeetingParticipantsConfirmed.AllowDrop := True;
  Self.dgridMeetingParticipantsConfirmed.AlternatingBackColor := System.Drawing.Color.WhiteSmoke;
  Self.dgridMeetingParticipantsConfirmed.BackColor := System.Drawing.Color.Gainsboro;
  Self.dgridMeetingParticipantsConfirmed.BackgroundColor := System.Drawing.Color.DarkGray;
  Self.dgridMeetingParticipantsConfirmed.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.dgridMeetingParticipantsConfirmed.CaptionBackColor := System.Drawing.Color.DarkKhaki;
  Self.dgridMeetingParticipantsConfirmed.CaptionFont := System.Drawing.Font.Create('M' +
    'icrosoft Sans Serif', 8);
  Self.dgridMeetingParticipantsConfirmed.CaptionForeColor := System.Drawing.Color.Black;
  Self.dgridMeetingParticipantsConfirmed.CaptionText := 'Participants in sel' +
  'ected meeting';
  Self.dgridMeetingParticipantsConfirmed.DataMember := '';
  Self.dgridMeetingParticipantsConfirmed.DataSource := Self.ehMeetingParticipantsConfirmed;
  Self.dgridMeetingParticipantsConfirmed.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.EcoDragDropExtender.SetEcoDropTarget(Self.dgridMeetingParticipantsConfirmed, 
      True);
  Self.dgridMeetingParticipantsConfirmed.FlatMode := True;
  Self.dgridMeetingParticipantsConfirmed.Font := System.Drawing.Font.Create('M' +
    'icrosoft Sans Serif', 8);
  Self.dgridMeetingParticipantsConfirmed.ForeColor := System.Drawing.Color.Black;
  Self.dgridMeetingParticipantsConfirmed.GridLineColor := System.Drawing.Color.Silver;
  Self.dgridMeetingParticipantsConfirmed.HeaderBackColor := System.Drawing.Color.Black;
  Self.dgridMeetingParticipantsConfirmed.HeaderFont := System.Drawing.Font.Create('M' +
    'icrosoft Sans Serif', 8);
  Self.dgridMeetingParticipantsConfirmed.HeaderForeColor := System.Drawing.Color.White;
  Self.dgridMeetingParticipantsConfirmed.LinkColor := System.Drawing.Color.DarkSlateBlue;
  Self.dgridMeetingParticipantsConfirmed.Location := System.Drawing.Point.Create(3, 
      152);
  Self.dgridMeetingParticipantsConfirmed.Name := 'dgridMeetingParticipantsCo' +
  'nfirmed';
  Self.dgridMeetingParticipantsConfirmed.ParentRowsBackColor := System.Drawing.Color.LightGray;
  Self.dgridMeetingParticipantsConfirmed.ParentRowsForeColor := System.Drawing.Color.Black;
  Self.dgridMeetingParticipantsConfirmed.RowHeadersVisible := False;
  Self.dgridMeetingParticipantsConfirmed.SelectionBackColor := System.Drawing.Color.Firebrick;
  Self.dgridMeetingParticipantsConfirmed.SelectionForeColor := System.Drawing.Color.White;
  Self.dgridMeetingParticipantsConfirmed.Size := System.Drawing.Size.Create(247, 
      247);
  Self.dgridMeetingParticipantsConfirmed.TabIndex := 18;
  // 
  // ehMeetingParticipantsConfirmed
  // 
  Column17.Expression := 'self.Name';
  Column17.Name := 'Name';
  Column18.Expression := 'self.asstring';
  Column18.Name := 'Type';
  Self.ehMeetingParticipantsConfirmed.Columns.AddRange(TArrayOfBorland_Eco_Handles_AbstractColumn.Create(Column17, 
          Column18));
  Self.ehMeetingParticipantsConfirmed.Expression := 'self.confirmedParticipa' +
  'nts';
  Self.ehMeetingParticipantsConfirmed.RootHandle := Self.cmhCurrentMeeting;
  // 
  // Confirmed
  // 
  Self.Confirmed.Format := '';
  Self.Confirmed.FormatInfo := nil;
  Self.Confirmed.MappingName := '';
  Self.Confirmed.Width := -1;
  // 
  // tabControlMain
  // 
  Self.tabControlMain.Controls.Add(Self.tabMeetings);
  Self.tabControlMain.Controls.Add(Self.tabParticipants);
  Self.tabControlMain.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.tabControlMain.Location := System.Drawing.Point.Create(5, 5);
  Self.tabControlMain.Name := 'tabControlMain';
  Self.tabControlMain.SelectedIndex := 0;
  Self.tabControlMain.Size := System.Drawing.Size.Create(658, 466);
  Self.tabControlMain.TabIndex := 14;
  // 
  // tabMeetings
  // 
  Self.tabMeetings.Controls.Add(Self.dgridMeetings);
  Self.tabMeetings.Controls.Add(Self.Panel1);
  Self.tabMeetings.DockPadding.All := 3;
  Self.tabMeetings.Location := System.Drawing.Point.Create(4, 22);
  Self.tabMeetings.Name := 'tabMeetings';
  Self.tabMeetings.Size := System.Drawing.Size.Create(650, 440);
  Self.tabMeetings.TabIndex := 1;
  Self.tabMeetings.Text := 'Meetings';
  // 
  // Panel1
  // 
  Self.Panel1.Controls.Add(Self.grboxCurrentMeeting);
  Self.Panel1.Controls.Add(Self.Panel4);
  Self.Panel1.Dock := System.Windows.Forms.DockStyle.Right;
  Self.Panel1.DockPadding.Left := 3;
  Self.Panel1.DockPadding.Top := 3;
  Self.Panel1.Location := System.Drawing.Point.Create(391, 3);
  Self.Panel1.Name := 'Panel1';
  Self.Panel1.Size := System.Drawing.Size.Create(256, 434);
  Self.Panel1.TabIndex := 2;
  // 
  // grboxCurrentMeeting
  // 
  Self.grboxCurrentMeeting.Controls.Add(Self.dgridMeetingParticipants);
  Self.grboxCurrentMeeting.Controls.Add(Self.dgridMeetingParticipantsConfirmed);
  Self.grboxCurrentMeeting.Controls.Add(Self.Panel2);
  Self.grboxCurrentMeeting.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.grboxCurrentMeeting.Location := System.Drawing.Point.Create(3, 32);
  Self.grboxCurrentMeeting.Name := 'grboxCurrentMeeting';
  Self.grboxCurrentMeeting.Size := System.Drawing.Size.Create(253, 402);
  Self.grboxCurrentMeeting.TabIndex := 21;
  Self.grboxCurrentMeeting.TabStop := False;
  Self.grboxCurrentMeeting.Text := 'Selected meeting';
  // 
  // Panel2
  // 
  Self.Panel2.Controls.Add(Self.rbtnConfirmedParticipants);
  Self.Panel2.Controls.Add(Self.rbtnAllParticipants);
  Self.Panel2.Controls.Add(Self.lblMeetingEndTime);
  Self.Panel2.Controls.Add(Self.tboxMeetingFrom);
  Self.Panel2.Controls.Add(Self.Label2);
  Self.Panel2.Controls.Add(Self.Label1);
  Self.Panel2.Controls.Add(Self.lblStartTime);
  Self.Panel2.Controls.Add(Self.tboxMeetingDuration);
  Self.Panel2.Controls.Add(Self.btnDeleteMeeting);
  Self.Panel2.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Panel2.Location := System.Drawing.Point.Create(3, 16);
  Self.Panel2.Name := 'Panel2';
  Self.Panel2.Size := System.Drawing.Size.Create(247, 136);
  Self.Panel2.TabIndex := 4;
  // 
  // rbtnConfirmedParticipants
  // 
  Self.rbtnConfirmedParticipants.Location := System.Drawing.Point.Create(72, 
      113);
  Self.rbtnConfirmedParticipants.Name := 'rbtnConfirmedParticipants';
  Self.rbtnConfirmedParticipants.Size := System.Drawing.Size.Create(152, 24);
  Self.rbtnConfirmedParticipants.TabIndex := 22;
  Self.rbtnConfirmedParticipants.Text := 'Confirmed Particpants';
  Include(Self.rbtnConfirmedParticipants.Click, Self.rbtnConfirmedParticipants_Click);
  // 
  // rbtnAllParticipants
  // 
  Self.rbtnAllParticipants.Checked := True;
  Self.rbtnAllParticipants.Location := System.Drawing.Point.Create(11, 113);
  Self.rbtnAllParticipants.Name := 'rbtnAllParticipants';
  Self.rbtnAllParticipants.Size := System.Drawing.Size.Create(40, 24);
  Self.rbtnAllParticipants.TabIndex := 21;
  Self.rbtnAllParticipants.TabStop := True;
  Self.rbtnAllParticipants.Text := 'All ';
  Include(Self.rbtnAllParticipants.Click, Self.rbtnConfirmedParticipants_Click);
  Include(Self.rbtnAllParticipants.CheckedChanged, Self.rbtnConfirmedParticipants_Click);
  // 
  // lblMeetingEndTime
  // 
  Self.lblMeetingEndTime.DataBindings.Add(System.Windows.Forms.Binding.Create('T' +
      'ext', Self.cmhCurrentMeeting, 'EndTime'));
  Self.lblMeetingEndTime.Location := System.Drawing.Point.Create(72, 82);
  Self.lblMeetingEndTime.Name := 'lblMeetingEndTime';
  Self.lblMeetingEndTime.Size := System.Drawing.Size.Create(120, 16);
  Self.lblMeetingEndTime.TabIndex := 19;
  Self.lblMeetingEndTime.Text := 'end';
  // 
  // tboxMeetingFrom
  // 
  Self.tboxMeetingFrom.DataBindings.Add(System.Windows.Forms.Binding.Create('T' +
      'ext', Self.cmhCurrentMeeting, 'Time'));
  Self.tboxMeetingFrom.Location := System.Drawing.Point.Create(72, 35);
  Self.tboxMeetingFrom.Name := 'tboxMeetingFrom';
  Self.tboxMeetingFrom.Size := System.Drawing.Size.Create(128, 20);
  Self.tboxMeetingFrom.TabIndex := 18;
  Self.tboxMeetingFrom.Text := '';
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(8, 82);
  Self.Label2.Name := 'Label2';
  Self.Label2.TabIndex := 3;
  Self.Label2.Text := 'EndTime';
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(8, 59);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(56, 23);
  Self.Label1.TabIndex := 2;
  Self.Label1.Text := 'Duration';
  // 
  // lblStartTime
  // 
  Self.lblStartTime.Location := System.Drawing.Point.Create(8, 35);
  Self.lblStartTime.Name := 'lblStartTime';
  Self.lblStartTime.TabIndex := 1;
  Self.lblStartTime.Text := 'StartTime';
  // 
  // tboxMeetingDuration
  // 
  Self.tboxMeetingDuration.DataBindings.Add(System.Windows.Forms.Binding.Create('T' +
      'ext', Self.cmhCurrentMeeting, 'Duration'));
  Self.tboxMeetingDuration.Location := System.Drawing.Point.Create(72, 59);
  Self.tboxMeetingDuration.Name := 'tboxMeetingDuration';
  Self.tboxMeetingDuration.Size := System.Drawing.Size.Create(50, 20);
  Self.tboxMeetingDuration.TabIndex := 0;
  Self.tboxMeetingDuration.Text := '';
  // 
  // Panel4
  // 
  Self.Panel4.Controls.Add(Self.btnNewMeeting);
  Self.Panel4.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Panel4.Location := System.Drawing.Point.Create(3, 3);
  Self.Panel4.Name := 'Panel4';
  Self.Panel4.Size := System.Drawing.Size.Create(253, 29);
  Self.Panel4.TabIndex := 22;
  // 
  // tabParticipants
  // 
  Self.tabParticipants.Controls.Add(Self.dgridParticipants);
  Self.tabParticipants.Controls.Add(Self.Panel6);
  Self.tabParticipants.DockPadding.All := 3;
  Self.tabParticipants.Location := System.Drawing.Point.Create(4, 22);
  Self.tabParticipants.Name := 'tabParticipants';
  Self.tabParticipants.RightToLeft := System.Windows.Forms.RightToLeft.No;
  Self.tabParticipants.Size := System.Drawing.Size.Create(650, 440);
  Self.tabParticipants.TabIndex := 2;
  Self.tabParticipants.Text := 'Persons, Groups & Resources';
  // 
  // Panel6
  // 
  Self.Panel6.Controls.Add(Self.gboxParticpants);
  Self.Panel6.Controls.Add(Self.Panel5);
  Self.Panel6.Dock := System.Windows.Forms.DockStyle.Right;
  Self.Panel6.DockPadding.Left := 3;
  Self.Panel6.DockPadding.Right := 3;
  Self.Panel6.DockPadding.Top := 3;
  Self.Panel6.Location := System.Drawing.Point.Create(391, 3);
  Self.Panel6.Name := 'Panel6';
  Self.Panel6.Size := System.Drawing.Size.Create(256, 434);
  Self.Panel6.TabIndex := 24;
  // 
  // gboxParticpants
  // 
  Self.gboxParticpants.Controls.Add(Self.dgridParticipantGroups);
  Self.gboxParticpants.Controls.Add(Self.Panel7);
  Self.gboxParticpants.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.gboxParticpants.Location := System.Drawing.Point.Create(3, 104);
  Self.gboxParticpants.Name := 'gboxParticpants';
  Self.gboxParticpants.Size := System.Drawing.Size.Create(250, 330);
  Self.gboxParticpants.TabIndex := 2;
  Self.gboxParticpants.TabStop := False;
  Self.gboxParticpants.Text := 'Selected Participants';
  // 
  // Panel7
  // 
  Self.Panel7.Controls.Add(Self.btnDeleteParticipant);
  Self.Panel7.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Panel7.Location := System.Drawing.Point.Create(3, 16);
  Self.Panel7.Name := 'Panel7';
  Self.Panel7.Size := System.Drawing.Size.Create(244, 64);
  Self.Panel7.TabIndex := 20;
  // 
  // Panel5
  // 
  Self.Panel5.Controls.Add(Self.btnNewGroup);
  Self.Panel5.Controls.Add(Self.btnNewResource);
  Self.Panel5.Controls.Add(Self.btnNewPerson);
  Self.Panel5.Dock := System.Windows.Forms.DockStyle.Top;
  Self.Panel5.Location := System.Drawing.Point.Create(3, 3);
  Self.Panel5.Name := 'Panel5';
  Self.Panel5.Size := System.Drawing.Size.Create(250, 101);
  Self.Panel5.TabIndex := 24;
  // 
  // btnNewGroup
  // 
  Self.btnNewGroup.Location := System.Drawing.Point.Create(137, 68);
  Self.btnNewGroup.Name := 'btnNewGroup';
  Self.btnNewGroup.Size := System.Drawing.Size.Create(96, 23);
  Self.btnNewGroup.TabIndex := 7;
  Self.btnNewGroup.Text := 'New Group';
  Include(Self.btnNewGroup.Click, Self.btnNewGroup_Click);
  // 
  // btnNewResource
  // 
  Self.btnNewResource.Location := System.Drawing.Point.Create(137, 38);
  Self.btnNewResource.Name := 'btnNewResource';
  Self.btnNewResource.Size := System.Drawing.Size.Create(96, 23);
  Self.btnNewResource.TabIndex := 6;
  Self.btnNewResource.Text := 'New Resource';
  Include(Self.btnNewResource.Click, Self.btnNewResource_Click);
  // 
  // Panel3
  // 
  Self.Panel3.Controls.Add(Self.btnSave);
  Self.Panel3.Controls.Add(Self.btnUndo);
  Self.Panel3.Controls.Add(Self.btnRedo);
  Self.Panel3.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.Panel3.DockPadding.All := 3;
  Self.Panel3.Location := System.Drawing.Point.Create(5, 471);
  Self.Panel3.Name := 'Panel3';
  Self.Panel3.Size := System.Drawing.Size.Create(658, 40);
  Self.Panel3.TabIndex := 3;
  // 
  // TWinFormMain
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.BackColor := System.Drawing.SystemColors.Control;
  Self.ClientSize := System.Drawing.Size.Create(668, 511);
  Self.Controls.Add(Self.tabControlMain);
  Self.Controls.Add(Self.Panel3);
  Self.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', Self.cmhCurrentMeeting, 
        'Caption'));
  Self.DockPadding.Left := 5;
  Self.DockPadding.Right := 5;
  Self.DockPadding.Top := 5;
  Self.ForeColor := System.Drawing.SystemColors.ControlText;
  Self.Name := 'TWinFormMain';
  Self.RightToLeft := System.Windows.Forms.RightToLeft.No;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'Meeting Manager';
  (System.ComponentModel.ISupportInitialize(Self.dgridMeetings)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dgridParticipants)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dgridParticipantGroups)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dgridMeetingParticipants)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dgridMeetingParticipantsConfirmed)).EndInit;
  Self.tabControlMain.ResumeLayout(False);
  Self.tabMeetings.ResumeLayout(False);
  Self.Panel1.ResumeLayout(False);
  Self.grboxCurrentMeeting.ResumeLayout(False);
  Self.Panel2.ResumeLayout(False);
  Self.Panel4.ResumeLayout(False);
  Self.tabParticipants.ResumeLayout(False);
  Self.Panel6.ResumeLayout(False);
  Self.gboxParticpants.ResumeLayout(False);
  Self.Panel7.ResumeLayout(False);
  Self.Panel5.ResumeLayout(False);
  Self.Panel3.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinFormMain.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinFormMain.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  FEcoSpace := TMeetingManagerEcoSpace.Create;
  rhRoot.EcoSpace := FEcoSpace;
  // The line below will automatically activate the ECO Space.
  // Remove the line if you wich to activate it manually
  FEcoSpace.Active := true;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

end.
